/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.specifiques;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.jni.TraitementsSpecifiques;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatSpecifiqueInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class LectureObjetDonneesApplicatives {
    private static Logger log = Logger.getLogger(LectureObjetDonneesApplicatives.class);

    public static Resultat traitement(TraitementsSpecifiques traitementsSpecifiques) throws ExceptionTraitement {
        try {
            if (traitementsSpecifiques != null) {
                ResultatSpecifiqueInfo resultatSpecifiqueInfo = new ResultatSpecifiqueInfo("Lecture d'objet de donn\u00e9es applicatives (jeton)");
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                resultatSpecifiqueInfo.setInfos(linkedHashMap);
                try {
                    traitementsSpecifiques.initialiseLibrairie();
                    byte[] byArray = traitementsSpecifiques.lectureObjetDonneesApplicatives();
                    if (byArray != null) {
                        try {
                            linkedHashMap.put("Valeur de l'attribut CKA_VALUE", "\n" + TraitementsUtil.getHexadecimal(byArray, 16));
                        }
                        catch (ClassCastException classCastException) {
                            log.error((Object)("Erreur de cast : " + classCastException.getMessage()));
                            throw new ExceptionTraitement(107, "Une erreur inattendue est survenue");
                        }
                    } else {
                        log.error((Object)"L'operation a retourne un ensemble d'attributs nul");
                        throw new ExceptionTraitement(107, "L'operation a retourne un ensemble d'attributs nul");
                    }
                    resultatSpecifiqueInfo.setRetour("Lecture du jeton r\u00e9alis\u00e9e avec succ\u00e8s (0x00000000)");
                }
                catch (PKCS11Exception pKCS11Exception) {
                    log.info((Object)("Traitement echoue : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                    resultatSpecifiqueInfo.setCodeRetour(pKCS11Exception.getErrorCode());
                }
                return resultatSpecifiqueInfo;
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(107, "L'interface des traitements sp\u00e9cifiques est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(107, "Une erreur inattendue est survenue");
        }
    }
}

